'use strict';
const MANIFEST = 'flutter-app-manifest';
const TEMP = 'flutter-temp-cache';
const CACHE_NAME = 'flutter-app-cache';

const RESOURCES = {"version.json": "317381ebf6ba760cae80eb9f43c5d866",
"index.html": "ba8028aab6b5f45477445ab754d0d073",
"/": "ba8028aab6b5f45477445ab754d0d073",
"main.dart.js": "a2477928f796adda108b91f8b2d67687",
"flutter.js": "6fef97aeca90b426343ba6c5c9dc5d4a",
"favicon.png": "d7555b52d53626c62c2530da4059f7e2",
"icons/Icon-192.png": "e4f07523e7df45320acb81ca2d6d77f1",
"icons/Icon-maskable-192.png": "e4f07523e7df45320acb81ca2d6d77f1",
"icons/Icon-maskable-512.png": "a7ff3eefc29b1852331a9e7d2f172902",
"icons/Icon-512.png": "a7ff3eefc29b1852331a9e7d2f172902",
"manifest.json": "03c81bdf6c8e7b176e577aabdd50b6e0",
"assets/AssetManifest.json": "27e2a9bbe63650058c4650740f1768b2",
"assets/NOTICES": "d12c7999a4b7ee522d04c26444415d24",
"assets/FontManifest.json": "e3d45c630c5ac58a48da04ab8e1a1e38",
"assets/packages/cupertino_icons/assets/CupertinoIcons.ttf": "b7daab826d368edc07aa442de70e90a5",
"assets/packages/fluttertoast/assets/toastify.js": "e7006a0a033d834ef9414d48db3be6fc",
"assets/packages/fluttertoast/assets/toastify.css": "a85675050054f179444bc5ad70ffc635",
"assets/shaders/ink_sparkle.frag": "f8b80e740d33eb157090be4e995febdf",
"assets/lib/l10n/intl_en.arb": "455e25abeca99fb218d613695a665b4a",
"assets/AssetManifest.bin": "d15ed90555e3ecc0207ebf3bd702fbaf",
"assets/fonts/MaterialIcons-Regular.otf": "de996130da84680a877655327a4a217a",
"assets/assets/offers/offer1.png": "68d45be31ae33c5bf00a7a988e2fd181",
"assets/assets/offers/offer3.png": "59217429f588a868a9d2d39a0911f416",
"assets/assets/offers/offer2.png": "e4a5e8a8f7e7d756a8292a3f01592f1d",
"assets/assets/icon.png": "9fec647e60d49af371a4966b90bb7971",
"assets/assets/images/add_money_to_wallet.svg": "08b1797b90337b416dcc4ff5ffd66af9",
"assets/assets/images/century_pool.png": "3a1bb5abf518a13f67f4a8049209036f",
"assets/assets/images/pool_sign_up.svg": "66863ad70f28f6595a93ea79dcee4d12",
"assets/assets/images/quotation_mark.png": "5210ada31de089e5366b3601a440dbc0",
"assets/assets/images/hand_wave.svg": "d94c1d7beff6431d7ec17a868ce33f8a",
"assets/assets/images/sign_up_ui1.svg": "7a91ef9120c27c0f5ba24d176d7852e6",
"assets/assets/images/enter_otp_main.svg": "855009b9ca42a4e33eaa7d9fa85efe29",
"assets/assets/images/no-profile.png": "77f5794e2eb49f7989b8f85e92cfa4e0",
"assets/assets/images/feed_back.svg": "6173b1b26770733b202c927350d3f036",
"assets/assets/images/enter_otp.svg": "4ff5cb726bce61a76d91758e14818d7c",
"assets/assets/images/otp_confirm.svg": "2a1a91cd955a596a65aaaa8f833ccf53",
"assets/assets/web_front_page/web_design_man.png": "6a3dcfba1705221cc845f57592b7e752",
"assets/assets/web_front_page/about_pool.png": "caa73c0178276097e10d90820baef0d9",
"assets/assets/web_front_page/gallery/pool1.png": "81e48c86ef8d6466b733ae340390e787",
"assets/assets/web_front_page/gallery/pool_with_woman.png": "7dc045c8059283fea3f1123ef9da852e",
"assets/assets/web_front_page/gallery/pool3.png": "f2b1f97dba3ba1070b679642e6f8680e",
"assets/assets/web_front_page/gallery/pool2.png": "c25c8f59243494dbf1cbb3942a397453",
"assets/assets/web_front_page/service_even_celebrate.png": "dbef9d848076c41abc53236feaa4021d",
"assets/assets/web_front_page/web_design_pool1.png": "d9b20eda613b42f45ce867f0f0b5e6ae",
"assets/assets/web_front_page/services_pool.png": "03b3bd08d5b0a2e2b90ea0035bd6ab9c",
"assets/assets/web_front_page/swimming.png": "681d448930be4e80422e6b8298e22ac2",
"assets/assets/web_front_page/about1.png": "ed06e9a46ddc2cd4e69f30dd0e7ae1c9",
"assets/assets/web_front_page/about2.png": "b547455a655ed40da9fb70e6f5e19d60",
"assets/assets/web_front_page/client_testimonial3.png": "15e1e31016d0989e37a6b1aebc3c7622",
"assets/assets/web_front_page/client_testimonial2.png": "ca22ad93c4b0c7d60a0e87ba7a4c4f8c",
"assets/assets/web_front_page/client_testimonial1.png": "732d4435ca17d8333dc1cda5e6aa7ea9",
"assets/assets/icons/SincaIcons.ttf": "029c1971487e4cd141c605e122dfb14e",
"assets/assets/lottie/offer.png": "add45ee96b4b1e5c86aa5276f237fd9d",
"assets/assets/lottie/enter_otp.json": "f70db47556aef284c33691e49d3dfd7a",
"canvaskit/skwasm.js": "1df4d741f441fa1a4d10530ced463ef8",
"canvaskit/skwasm.wasm": "6711032e17bf49924b2b001cef0d3ea3",
"canvaskit/chromium/canvaskit.js": "8c8392ce4a4364cbb240aa09b5652e05",
"canvaskit/chromium/canvaskit.wasm": "fc18c3010856029414b70cae1afc5cd9",
"canvaskit/canvaskit.js": "76f7d822f42397160c5dfc69cbc9b2de",
"canvaskit/canvaskit.wasm": "f48eaf57cada79163ec6dec7929486ea",
"canvaskit/skwasm.worker.js": "19659053a277272607529ef87acf9d8a"};
// The application shell files that are downloaded before a service worker can
// start.
const CORE = ["main.dart.js",
"index.html",
"assets/AssetManifest.json",
"assets/FontManifest.json"];

// During install, the TEMP cache is populated with the application shell files.
self.addEventListener("install", (event) => {
  self.skipWaiting();
  return event.waitUntil(
    caches.open(TEMP).then((cache) => {
      return cache.addAll(
        CORE.map((value) => new Request(value, {'cache': 'reload'})));
    })
  );
});
// During activate, the cache is populated with the temp files downloaded in
// install. If this service worker is upgrading from one with a saved
// MANIFEST, then use this to retain unchanged resource files.
self.addEventListener("activate", function(event) {
  return event.waitUntil(async function() {
    try {
      var contentCache = await caches.open(CACHE_NAME);
      var tempCache = await caches.open(TEMP);
      var manifestCache = await caches.open(MANIFEST);
      var manifest = await manifestCache.match('manifest');
      // When there is no prior manifest, clear the entire cache.
      if (!manifest) {
        await caches.delete(CACHE_NAME);
        contentCache = await caches.open(CACHE_NAME);
        for (var request of await tempCache.keys()) {
          var response = await tempCache.match(request);
          await contentCache.put(request, response);
        }
        await caches.delete(TEMP);
        // Save the manifest to make future upgrades efficient.
        await manifestCache.put('manifest', new Response(JSON.stringify(RESOURCES)));
        // Claim client to enable caching on first launch
        self.clients.claim();
        return;
      }
      var oldManifest = await manifest.json();
      var origin = self.location.origin;
      for (var request of await contentCache.keys()) {
        var key = request.url.substring(origin.length + 1);
        if (key == "") {
          key = "/";
        }
        // If a resource from the old manifest is not in the new cache, or if
        // the MD5 sum has changed, delete it. Otherwise the resource is left
        // in the cache and can be reused by the new service worker.
        if (!RESOURCES[key] || RESOURCES[key] != oldManifest[key]) {
          await contentCache.delete(request);
        }
      }
      // Populate the cache with the app shell TEMP files, potentially overwriting
      // cache files preserved above.
      for (var request of await tempCache.keys()) {
        var response = await tempCache.match(request);
        await contentCache.put(request, response);
      }
      await caches.delete(TEMP);
      // Save the manifest to make future upgrades efficient.
      await manifestCache.put('manifest', new Response(JSON.stringify(RESOURCES)));
      // Claim client to enable caching on first launch
      self.clients.claim();
      return;
    } catch (err) {
      // On an unhandled exception the state of the cache cannot be guaranteed.
      console.error('Failed to upgrade service worker: ' + err);
      await caches.delete(CACHE_NAME);
      await caches.delete(TEMP);
      await caches.delete(MANIFEST);
    }
  }());
});
// The fetch handler redirects requests for RESOURCE files to the service
// worker cache.
self.addEventListener("fetch", (event) => {
  if (event.request.method !== 'GET') {
    return;
  }
  var origin = self.location.origin;
  var key = event.request.url.substring(origin.length + 1);
  // Redirect URLs to the index.html
  if (key.indexOf('?v=') != -1) {
    key = key.split('?v=')[0];
  }
  if (event.request.url == origin || event.request.url.startsWith(origin + '/#') || key == '') {
    key = '/';
  }
  // If the URL is not the RESOURCE list then return to signal that the
  // browser should take over.
  if (!RESOURCES[key]) {
    return;
  }
  // If the URL is the index.html, perform an online-first request.
  if (key == '/') {
    return onlineFirst(event);
  }
  event.respondWith(caches.open(CACHE_NAME)
    .then((cache) =>  {
      return cache.match(event.request).then((response) => {
        // Either respond with the cached resource, or perform a fetch and
        // lazily populate the cache only if the resource was successfully fetched.
        return response || fetch(event.request).then((response) => {
          if (response && Boolean(response.ok)) {
            cache.put(event.request, response.clone());
          }
          return response;
        });
      })
    })
  );
});
self.addEventListener('message', (event) => {
  // SkipWaiting can be used to immediately activate a waiting service worker.
  // This will also require a page refresh triggered by the main worker.
  if (event.data === 'skipWaiting') {
    self.skipWaiting();
    return;
  }
  if (event.data === 'downloadOffline') {
    downloadOffline();
    return;
  }
});
// Download offline will check the RESOURCES for all files not in the cache
// and populate them.
async function downloadOffline() {
  var resources = [];
  var contentCache = await caches.open(CACHE_NAME);
  var currentContent = {};
  for (var request of await contentCache.keys()) {
    var key = request.url.substring(origin.length + 1);
    if (key == "") {
      key = "/";
    }
    currentContent[key] = true;
  }
  for (var resourceKey of Object.keys(RESOURCES)) {
    if (!currentContent[resourceKey]) {
      resources.push(resourceKey);
    }
  }
  return contentCache.addAll(resources);
}
// Attempt to download the resource online before falling back to
// the offline cache.
function onlineFirst(event) {
  return event.respondWith(
    fetch(event.request).then((response) => {
      return caches.open(CACHE_NAME).then((cache) => {
        cache.put(event.request, response.clone());
        return response;
      });
    }).catch((error) => {
      return caches.open(CACHE_NAME).then((cache) => {
        return cache.match(event.request).then((response) => {
          if (response != null) {
            return response;
          }
          throw error;
        });
      });
    })
  );
}
